// Tracker_alphaBeta.h: interface for the Tracker_alphaBeta class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRACKER_ALPHABETA_H__BE814528_75E3_45C6_8207_FB178ECE1463__INCLUDED_)
#define AFX_TRACKER_ALPHABETA_H__BE814528_75E3_45C6_8207_FB178ECE1463__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Tracker.h"
#include "Tracker_alphaBeta.h"

class Tracker_alphaBeta : public Tracker  
{
public:
	Tracker_alphaBeta();
	virtual ~Tracker_alphaBeta();
	void Deactivate(void) ;
	TRACKER_ERRORS Activate(void) ;
	TRACKER_ERRORS RunAlphaBeta(long ping) ;
	TRACKER_ERRORS SetTrackerParam(double alphaIn, double betaIn, double Gate);

private:
	TRACKER_ERRORS prediction(long ping, EchoCacheElement * firstEcho);
	TRACKER_ERRORS association(long ping, EchoCacheElement * firstEcho);
	bool shouldEndTrack (Track * track, long ping);
	double gate;			// initial gate size [samples]
	double alpha;			// scaling parameter for velocity update
	double beta;			// scaling parameter for position update
	int terminationThreshold;	
};


#endif // !defined(AFX_TRACKER_ALPHABETA_H__BE814528_75E3_45C6_8207_FB178ECE1463__INCLUDED_)

